//------------------------------------------------------------------------------
// File: svr_parade.cs
// This file contains the server methods and data for the parade and party hats
// Author: Matthew Rudge
//------------------------------------------------------------------------------

//-Globals----------------------------------------------------------------------
// List of party hats and mount points
$PartyHat[0] = "PartySombrero";
$PartyHat[1] = "PartySombrero";
$PartyHatCount = 2;
$PartyHatSlot  = 0;
// etc.
//------------------------------------------------------------------------------

//-Methods----------------------------------------------------------------------
function paradeStart(%cmdData, %building)
{
   // start the parade effect
   startEffect(%object, "parade");
   
   // Get all characters on player team
   %teamChars = paradeGetTeamCharacters();
   
   // Swap hats
   paradeSwapHats(%teamChars, MaleCiv, true);
   paradeSwapHats(%teamChars, FemaleCiv, true);
   
   // Delete team list
   %teamChars.delete();
   
   // Create timer to unmount hats (10 seconds)
   %timer = new SLTimer()
   {
      time = 45.0;
   };
   %timer.notifyOnFire("paradeEnd");
   
   startHappinessAttack(%cmdData, %building);
   
   // Play parade sound
   %count = ClientGroup.getCount();
   for(%i = 0; %i < %count; %i++) {
      %client = ClientGroup.getObject(%i);
      commandToClient(%client, 'PlaySFXSound', "audio_parade");
   }
}

function paradeEnd()
{
   // stop the parade effect
   stopEffect(%object, "parade");
   
   // Get all characters on player team
   %teamChars = paradeGetTeamCharacters();
   
   // Swap hats
   paradeSwapHats(%teamChars, MaleCiv, false);
   paradeSwapHats(%teamChars, FemaleCiv, false);
   
   // Delete team list
   %teamChars.delete();
}

function paradeGetTeamCharacters()
{
   // Get all characters
   %charList = slgGetServerCharacterList();
   if(!isObject(%charList)) {
      return;
   }
   
   // Create team list
   %teamChars  = new SLGameObjList();
   if(!isObject(%teamChars)) {
      return;
   }
   
   // Get all characters on player team
   %charList.getTeamList($OST_PLAYER, %teamChars);
   return %teamChars;
}

function paradeSwapHats(%teamList, %objType, %bParty)
{
   // Create final list
   %finalChars = new SLGameObjList();
   if(!isObject(%finalChars)) {
      return;
   }
   
   // Get all male characters
   %teamList.getTypeList(%objType, %finalChars);
   
   // Go through each and mount a party hat
   %size = %finalChars.getSize();
   %hatNum = 0;
   for(%i = 0; %i < %finalChars.getSize(); %i++) {
      %char = %finalChars.getID(%i);
      if(isObject(%char)) {
         
         // Get "random" hat image if a party
         %hatImage = "";
         if(%bParty) {
            // Mount new image
            %char.unmountImage($PartyHatSlot);
            if($PartyHat[%hatNum] !$= "")
            {
               if ($PartyHatSlot != 0 || $HatEnabled == true)
               {
                  %char.mountImage($PartyHat[%hatNum], $PartyHatSlot);
               }
            }
         }
         // Restore hat
         else {
            %cmpAI = slgQueryInterface(%char, $CID_AI);
            if(isObject(%cmpAI)) {
               RestoreCharacterOutfit(%cmpAI);
            }
         }
         
         
         
         // Update hat number
         %hatNum++;
         if(%hatNum >= $PartyHatCount) {
            %hatNum = 0;
         }
      }
   }
   
   // Destroy final list
   %finalChars.delete();
}

//------------------------------------------------------------------------------
// End svr_parade.cs
